/************************************************************************\
	Convert Unicode to "Content-Transfer-Encoding: quoted-printable"
	Uses modified ISO-8859-1 (Latin-1) character encoding
\************************************************************************/

#include "objects.h"
#include "NewtonScript.h"

extern const char uni0x80To7Bit[];
extern const UShort uni2isoTbl[];
extern long	_stuffQPChar ( char *buff, long offset, UShort uniChar );
extern long	_stuff7BitEquiv ( char *buff, long offset, UShort uniChar );

static void		_WrapTxQuoted ( UShort *src, char *dest, long offset, long maxW, RefArg txFunc );
static void		_WrapTxASCII  ( UShort *src, char *dest, long offset, long maxW, RefArg txFunc );
static Boolean	_finishLine ( char *buff, long ix, char doQuote, long offset, RefArg txFunc );

extern "C" Ref WrapTxAsyn ( RefArg rcvr, RefArg srcUnicode, RefArg destBinObj, RefArg startOffset, RefArg maxW, RefArg txFunc, RefArg doQuotedP )
{
/*
	if ( !IsString(srcUnicode) )
		ThrowBadTypeWithFrameData ( -48402, srcUnicode );	// expected a string

	if ( !IsBinary(destBinObj) )
		ThrowBadTypeWithFrameData ( -48408, destBinObj );	// expected a binary object

	if ( !IsInt(startOffset) )
		ThrowBadTypeWithFrameData ( -48406, startOffset );	// expected an integer

	if ( !IsInt(maxW) )
		ThrowBadTypeWithFrameData ( -48406, maxW );			// expected an integer

	if ( !IsFunction(txFunc) )
		ThrowBadTypeWithFrameData ( -48411, txFunc );		// expected a function
*/
	long	maxWidth = RefToInt ( maxW );
	long	offset = RefToInt ( startOffset );

	WITH_LOCKED_BINARY ( srcUnicode, srcP )
	WITH_LOCKED_BINARY ( destBinObj, destP )

	if ( doQuotedP == NILREF )
		_WrapTxASCII  ( (UShort *)srcP, (char *)destP, offset, maxWidth, txFunc );
	else
		_WrapTxQuoted ( (UShort *)srcP, (char *)destP, offset, maxWidth, txFunc );

	END_WITH_LOCKED_BINARY ( srcUnicode )
	END_WITH_LOCKED_BINARY ( destBinObj )

	return NILREF;
}


static void _WrapTxQuoted ( UShort *src, char *dest, long offset, long maxW, RefArg txFunc )
{
	//char	outBuff[256];
	char	*outBuff = dest;
	long	i = offset;
	long	k = 0;
	UShort	ch;
	long	prevSrcSpc = i;
	long	prevDstSpc = 0;

	while ( ch = src[i] )
	{
		// quote first "." character on a line
		if ( k == 0 && ch == 0x2E )
		{
			k = _stuffQPChar ( outBuff, k, ch );
			i++;
		}
		else
		{
			if ( k > (maxW-2) && ch != 0x0D )
			{
				// split right here if no spaces in this line
				if ( prevDstSpc < maxW / 4 )
				{
					if ( ! _finishLine ( outBuff, k, true, i, txFunc ) ) return;
				}
				else
				{
					i = prevSrcSpc + 1;

					if ( ! _finishLine ( outBuff, prevDstSpc + 1, true, i, txFunc ) ) return;
				}
				prevSrcSpc = i;
				prevDstSpc = 0;
				k = 0;
			}
			else
			{
				// keep track of <SPC> char positions
				if ( ch == 0x20 )
				{
					prevSrcSpc = i;
					prevDstSpc = k;
				}

				// if we're at a <CR> finish the line and reset "k"
				else if ( ch == 0x0D )
				{
					// LRT - 97/01/24 12:38 PM
					// Bug from Apple Australia
					// was incrementing over the first character in lines
					// which ended with a hard <CR>
					// WAS:
					//	i++;
					// REMOVED

					// LRT - 97/01/24 12:37 PM
					// must escape the end of line <CR> because we insert an =0D
					// WAS:
					//if ( ! _finishLine ( outBuff, k, nil, i, txFunc ) ) return;
					// NEW:
					//if ( ! _finishLine ( outBuff, k, true, i, txFunc ) ) return;
					// LRT - 97/01/24 4:52 PM
					if ( ! _finishLine ( outBuff, k, nil, i, txFunc ) ) return;
					prevSrcSpc = i;
					prevDstSpc = 0;
					k = 0;
				}

				// LRT - 97/01/24 4:18 PM
				// quote the 1st character on the line if the first word
				// begins with "F" and ends with ":" and there's been no
				// space or translation yet
				else if ( ch == ':' && prevDstSpc == 0 && outBuff[0] == 'F' )
				{
					long x;
					//move all but the 1st character ahead 2 places
					// so we can replace the 1st char with "=HH"
					for ( x = k; x > 0; x-- )
					{
						outBuff[x+2] = outBuff[x];
					}
					x = _stuffQPChar ( outBuff, 0, outBuff[0] );	// quote the 1st character

					k += 2;		// point k beyond our move
					//i++;
				}
				/***** WAS
				if ( prevDstSpc == 0 && ch == ':' )
				{
					k = _stuffQPChar ( outBuff, k, ch );
					prevSrcSpc = i;
					prevDstSpc = k;
					i++;
				}

				// do characters which have to be quoted
				else if ( ch == '=' || ch > 0x7E || ch < 0x20 )
				**********/

				// do characters which have to be quoted
				if ( ch == '=' || ch > 0x7E || ch < 0x20 )
				{
					if ( ch != 0x0D )
						k = _stuffQPChar ( outBuff, k, ch );
					i++;
				}

				// just stuff in normal characters
				else
				{
					outBuff [ k++ ] = ch;
					i++;
				}
			}
		}
	}

	if ( k > 0 )
	{
		_finishLine ( outBuff, k, nil, -1, txFunc );
	}
	else
	{
		outBuff [ 0 ] = 0x00;
		NSCall ( txFunc, MakeString ( outBuff ), MakeInt ( -1 ) );
	}
}


static void _WrapTxASCII ( UShort *src, char *dest, long offset, long maxW, RefArg txFunc )
{
	char	*outBuff = dest;
	long	i = offset;
	long	k = 0;
	UShort	ch;
	long	prevSrcSpc = i;
	long	prevDstSpc = 0;

	while ( ch = src[i] )
	{
		// convert solitary first "." character on a line
		// to double ".."
		if ( k == 0 && ch == 0x2E && !(src[i] == 0x2E) )
		{
			outBuff[k++] = 0x2E;
			outBuff[k++] = 0x2E;
			i++;
		}
		else
		{
			if ( k > (maxW-1) && ch != 0x0D )
			{
				// split right here if no spaces in this line
				if ( prevDstSpc < maxW / 4 )
				{
					if ( ! _finishLine ( outBuff, k, nil, i, txFunc ) ) return;
				}
				else
				{
					i = prevSrcSpc + 1;		// point 1 beyond the space <7-bit>

					if ( ! _finishLine ( outBuff, prevDstSpc, nil, i, txFunc ) ) return;
				}
				prevSrcSpc = i;
				prevDstSpc = 0;
				k = 0;
			}
			else
			{
				// keep track of <SPC> char positions
				if ( ch == 0x20 )
				{
					prevSrcSpc = i;
					prevDstSpc = k;
				}

				// do characters which have to be quoted
				if ( ch > 0x7E )
				{
					k = _stuff7BitEquiv ( outBuff, k, ch );
					i++;
				}

				// if we're at a <CR> finish the line and reset "k"
				else if ( ch == 0x0D )
				{
					i++;
					if ( ! _finishLine ( outBuff, k, nil, i, txFunc ) ) return;
					prevSrcSpc = i;
					prevDstSpc = 0;
					k = 0;
				}

				// LRT - 97/01/25 12:06 AM
				// If the first word begins with "F" and ends with ":"
				// and there's been no space or translation yet,
				// we'll insert a single space before the ":"
				else if ( ch == ':' && prevDstSpc == 0 && outBuff[0] == 'F' )
				{
					outBuff [ k++ ] = ' ';
					outBuff [ k++ ] = ':';
					i++;
				}

				// replace TAB characters with multiple spaces
				/**********************************************
				else if ( ch == 0x09 )
				{
					long tabIx;
					for ( tabIx = 0; tabIx < 4; tabIx++ )
					{
						outBuff [ k++ ] = 0x20;
					}
					i++;
				}
				**********************************************/

				// just stuff in normal characters
				else
				{
					outBuff [ k++ ] = ch;
					i++;
				}
			}
		}
	}

	if ( k > 0 )
	{
		_finishLine ( outBuff, k, nil, -1, txFunc );
	}
	else
	{
		outBuff [ 0 ] = 0x00;
		NSCall ( txFunc, MakeString ( outBuff ), MakeInt ( -1 ) );
	}
}


static Boolean _finishLine ( char *buff, long ix, char doQuote, long offset, RefArg txFunc )
{
	if ( doQuote )
		buff [ ix++ ] = '=';

	buff [ ix++ ] = 0x0D;
	buff [ ix   ] = 0x0A;

	buff [ ix+1 ] = 0x00;

	Ref keepGoing = 
		NSCall ( txFunc, MakeString ( buff ), MakeInt ( offset ) );

	return ISTRUE ( keepGoing );
}
